<?php
/**
 * Created by PhpStorm.
 * User: Villa
 * Date: 03/12/2018
 * Time: 16:21
 */


trait Trait_InutraliaWS {

    public function save_token_credentials ($token_auth){
        \Session::set('token_auth',$token_auth);
    }

    public function get_header(){


        return array(
            'Content-Type: application/json',
            'Accept: application/json',
            'Authorization: Basic '. \Session::get('token_auth'),
        );

    }

    /**
     *
     * Metodo generico para relaizar peticiones al WS de inutralia
     *
     * MORE INFO CURL --> http://php.net/manual/es/function.curl-setopt.php
     *
     * @param $url
     * @param string $method
     * @param int $return_transfer
     * @param array $extra_options --> Opciones extra para la request curl, arrat(key, opcion curl / value, valor curl).
     * @param array $add_params_header --> Array para añadir mas opciones a la cabecera por defecto.
     * @return mixed
     */
    public function request_generic($url, $method = "get", $return_transfer = 1, $extra_options = array(),$add_params_header = array()){

        $constant = \Config::load('constants','config',true);

        // La url la obtiene de config dependiendo del entorno.
        $ch = curl_init($constant['domain'].$url.$constant['apikey']);

        curl_setopt($ch, CURLOPT_HTTPHEADER,array_merge($this->get_header(),$add_params_header));

        curl_setopt($ch, $method == "get" ? CURLOPT_HTTPGET :CURLOPT_POST , 1);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, $return_transfer);

        foreach ($extra_options as $key => $value){
            curl_setopt($ch, $key, $value);
        }


        $return = curl_exec($ch);

        curl_close($ch);

        return $return;
    }

    /**
     *
     * User auth basic request for login, save the user token in session for all requests.
     *
     * @param $user
     * @param $password
     */

    public function ws_user($user,$password){

        $this->save_token_credentials(base64_encode("$user:$password"));

        return json_decode($this->request_generic('user'));

    }

    /**
     * Reques profile get
     *
     * @param null $data
     * @return mixed
     */
    public function ws_profile_get(){

        return json_decode($this->request_generic('profile'));

    }

    /**
     * Reques profile put
     *
     * @param $data
     * @return mixed
     */
    public function ws_profile_put($id, $data){

        $data_json = json_encode($data);

        $extra_options = array(
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_POSTFIELDS => $data_json
        );

        return json_decode($this->request_generic('profile'.DS.$id,"post",1,$extra_options,array('Content-Length: ' . strlen($data_json))));

    }

    public function ws_article_get(){

        return json_decode($this->request_generic('article'));

    }

    public function ws_recipe_get($id = null){

        if(!$id){
            return json_decode($this->request_generic('recipe'));
        }else{
            return json_decode($this->request_generic('recipe/'.$id));
        }

    }

    public function ws_options_get(){

        return json_decode($this->request_generic('options'));

    }

    public function ws_options_post(){

        return json_decode($this->request_generic('options'));

    }


}