<?php
/**
 * SETI Consultyn S.L.
 * www.seticonsultyn.es
 *
 * Copyright(c) 2011-2013
 *
 * PHP Version 5.4.x
 *
 * @category  Libraries
 * @package   App
 * @author    Luis Torres @ SETI Consultyn S.L. <contacto@seticonsultyn.es>
 * @copyright 2011-2013 SETI Consultyn S.L. http://seticonsultyn.com/copyright.txt
 * @license   SETI Consultyn Software License <license.txt>
 * @version   GIT: $Rev$
 * @link      http://seticonsultyn.com
 */

use Auth\Auth;
use Fuel\Core\Controller;
use Fuel\Core\Session;

class Controller_App extends Controller{

    public function before(){

        if (! Auth::check() ){
            Response::redirect("/");
            Session::destroy();
        }

        Config::load('app', true);

        parent::before();
    }

    public function post_locale(){

        $id = Input::post('id','');

        $localidades = Model_Localidad::query()->where('provincia_id',$id)->get();

        $array_localidades = array();
        foreach($localidades as $localidad){
            $array_localidades[$localidad->id] = $localidad->ds;
        }

        return new \Response(json_encode(array('localidades' => $array_localidades)));
    }
}