<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Auth\Auth;
use Auth\UserDisabledException;
use Auth\UserNotFoundException;
use Auth\UserPasswordIncorrectException;
use Auth\UserUnverifiedException;
use Fuel\Core\Log;
use Fuel\Core\Response;
use Fuel\Core\Security;

class Controller_Login_Index extends Controller{


  public function get_login()
  {
    // redirects if the user is logged
    if (Auth::check()) {

      $datos = \Config::load('empresa');
      Session::set('empresa',$datos);

      return Response::redirect('/dashboard');
    }

    $view = View::forge('login.twig');
    return $view;
  }

  public function post_login()
  {
    $datos = \Config::load('empresa');
    Session::set('empresa',$datos);

    // performs de validation
    if (!Security::check_token()) {
      Session::set_flash(
          'message:error',
          'Se perdio la ventana de autenticación, ha pasado demasiado tiempo
                inactivo, intentelo de nuevo.'
      );
      Response::redirect('auth/login');
      return null;
    }

    $val = Validation::forge();
    $val->add('username', 'Correo Electronico')
        ->add_rule('required');
    $val->add('password', 'Contraseña')
        ->add_rule('required');

    // seteamos el old input
    Session::set_flash('login:username', \Input::post('username'));

    if ($val->run()) {
      try {
        Auth::attempt(
            array(
                'username' => $val->validated('username'),
                'password' => $val->validated('password')
            )
        );

        $usu = array(
            'username' => $val->validated('username'),
            'nombre' => $val->validated('password')
        );

        Session::set('usuario',$usu);

        Response::redirect('/dashboard');

        return null;

      } catch (UserNotFoundException $e) {
        Session::set_flash(
            'message:error',
            'No es posible entrar, email o contraseña incorrecto'
        );
        Response::redirect('auth/login');
        return null;
      }
      catch (UserUnverifiedException $e) {
        Session::set_flash(
            'message:error',
            'La cuenta a la que intenta conectarse no esta verificada aún. Inténtelo más tarde.'
        );
        Response::redirect('auth/login');
        return null;
      }
      catch (UserPasswordIncorrectException $e) {
        Session::set_flash(
            'message:error',
            'No es posible entrar, email o contraseña incorrecto'
        );
        Response::redirect('auth/login');
        return null;
      }
      catch (UserDisabledException $e) {
        Session::set_flash(
            'message:error',
            '"No es posible acceder a tu cuenta porque está desactivada. Por favor, contacta con nuestro equipo de atención al cliente."'
        );
        Response::redirect('auth/login');
        return null;
      }
    } else {
      Session::set_flash(
          'message:error',
          'Para entrar en tu cuenta tienes que introducir tu email y contraseña.'
      );

      Response::redirect('auth/login');
      return null;
    }
  }

  public function get_logout()
  {
    Auth::logout();
    Response::redirect('/');
  }

  public function get_recover(){
    $view = View::forge('recover.twig');

    return Response::forge ($view);
  }

  public function post_recover()
  {

    $usuario = Model_Auth_User::query()
        ->where('user',Input::Post('username',''))
        ->related('group')
        ->get_one();

    if(isset($usuario) && $usuario->valid == 1)
    {
      $view =  \View::forge("emails/pedidos/adminResend");

      $view->user = $usuario->user;
      $view->password = $usuario->password;

      $body = $view->render();

      $comu_session = Config::get('email');

      $error = false;
      //Preparar envio
      try
      {
        $transport = Swift_SmtpTransport::newInstance($comu_session['smtp'], $comu_session['port'], 'tls')
            ->setUsername($comu_session['user'])->setPassword($comu_session['password']);

        $mailer = Swift_Mailer::newInstance($transport);

      }
      catch(Exception $e)
      {
        Log::error('Error Enviando correo1 - >'. $e->getMessage());
        $error = true;
      }//endCatch

      //Enviar Correo
      if (!$error)
      {
        try
        {
          $message = Swift_Message::newInstance("Recuperación de contraseña")
              ->setFrom(array ($comu_session['emailfrom'] => $comu_session['emailfrom']))
              ->setBody($body, 'text/html');

          $message->setTo(array ($comu_session['email'] => $comu_session['email']));

          $mailer->send($message);

        }
        catch(Exception $e)
        {
          Log::error('Error Enviando corre2 - >'. $e->getMessage());
          $error = true;
        }//endCatch
      }//endIf

      if ($error)
      {
        Session::set_flash('msges.error',array('Error enviando correo.')); //Enviar Notifys!!!
      }
      else
      {
        Session::set_flash('msges.ok',array('Correos enviados correctamente.'));
      }//endIf

      Response::redirect('/');
    }
    else
    {
      //notificar Usuario no valido

      Response::redirect('recover');
    }
  }


}