<?php
/**
 * SETI Consultyn S.L.
 * www.seticonsultyn.es
 *
 * Copyright(c) 2011-2013
 *
 * PHP Version 5.4.x
 *
 * @category  Libraries
 * @package   App
 * @author    Ignacio Muñoz @ SETI Consultyn S.L. <contacto@seticonsultyn.es>
 * @copyright 2011-2013 SETI Consultyn S.L. http://seticonsultyn.com/copyright.txt
 * @license   SETI Consultyn Software License <license.txt>
 * @version   GIT: $Rev$
 * @link      http://seticonsultyn.com
 */
use Fuel\Core\Fuel;
use Fuel\Core\Lang;
use Fuel\Core\Session;

/**
 * Provides Twig support for commonly used FuelPHP classes and methods.
 */
class Twig_Seti_Extension extends Twig_Extension
{
    /**
     * Gets the name of the extension.
     *
     * @return  string
     */
    public function getName()
    {
        return 'seti';
    }


    public function getFilters()
    {
        return array(
            'date_parse'    => new Twig_Filter_Function(function($string, $input_format, $output_format){
                return date_format(date_create_from_format($input_format, $string), $output_format);
            })
        );
    }

    /**
     * Sets up all of the functions this extension makes available.
     *
     * @return  array
     */
    public function getFunctions()
    {
        return array(

            'count'             => new Twig_Function_Function('count'),
            'min'             => new Twig_Function_Function('min'),

            'fuel_version'      => new Twig_Function_Method($this, 'fuel_version'),
            'fuel_env'          => new Twig_Function_Method($this, 'fuel_environment'),
            'url'               => new Twig_Function_Method($this, 'url'),
            'base_url'          => new Twig_Function_Function('Uri::base'),
            'current_url'       => new Twig_Function_Function('Uri::current'),
            'uri_segment'       => new Twig_Function_Function('Uri::segment'),
            'uri_segments'      => new Twig_Function_Function('Uri::segments'),
            'config'            => new Twig_Function_Function('Config::get'),
            'lang'              => new Twig_Function_Function('Lang::get'),
            'view'              => new Twig_Function_Function('View::forge'),
            'viewmodel'         => new Twig_Function_Function('ViewModel::forge'),
            'form_open'         => new Twig_Function_Function('Form::open'),
            'form_close'        => new Twig_Function_Function('Form::close'),
            'form_input'        => new Twig_Function_Function('Form::input'),
            'form_password'     => new Twig_Function_Function('Form::password'),
            'form_hidden'       => new Twig_Function_Function('Form::hidden'),
            'form_radio'        => new Twig_Function_Function('Form::radio'),
            'form_checkbox'     => new Twig_Function_Function('Form::checkbox'),
            'form_textarea'     => new Twig_Function_Function('Form::textarea'),
            'form_file'         => new Twig_Function_Function('Form::file'),
            'form_button'       => new Twig_Function_Function('Form::button'),
            'form_reset'        => new Twig_Function_Function('Form::reset'),
            'form_submit'       => new Twig_Function_Function('Form::submit'),
            'form_select'       => new Twig_Function_Function('Form::select'),
            'form_label'        => new Twig_Function_Function('Form::label'),
            'form_val'          => new Twig_Function_Function('Input::param'),

            'asset_add_path'    => new Twig_Function_Function('Asset::add_path'),
            'asset_css'         => new Twig_Function_Function('Casset::css'),
            'nasset_css'         => new Twig_Function_Function('Asset::css'),
            'asset_js'          => new Twig_Function_Function('Casset::js'),
            'asset_img'         => new Twig_Function_Function('Asset::img'),
            'asset_render_js'   => new Twig_Function_Function('Casset::render_js'),
            'asset_render_css'  => new Twig_Function_Function('Casset::render_css'),
            'asset_render'      => new Twig_Function_Function('Asset::render'),

            'html_anchor'       => new Twig_Function_Function('Html::anchor'),

            'input_get'         => new Twig_Function_Function('Input::get'),
            'input_post'        => new Twig_Function_Function('Input::post'),
            'input_param'         => new Twig_Function_Function('Input::param'),
            'input_ajax'        => new Twig_Function_Function('Input::is_ajax'),
            'input_pjax'        => new Twig_Function_Function('Input::is_pjax'),

            'session_get_flash' => new Twig_Function_Function('Session::get_flash'),
            'session_get'       => new Twig_Function_Function('Session::get'),
            'str_truncate'       => new Twig_Function_Function('Str::truncate'),

            'lang_frontend'         => new Twig_Function_Method($this, 'fetchFrontendLang'),
            'form_csrf'             => new Twig_Function_Method($this, 'fetchTokenCsrf'),
            'flash_alert'           => new Twig_Function_Method($this, 'printFlashAlert'),
            'auth_check'            => new Twig_Function_Function('Auth\\Auth::check'),
            'auth_guest'            => new Twig_Function_Function('Auth\\Auth::guest'),
            'auth_is'               => new Twig_Function_Function('Auth\\Auth::is'),
            'auth_is_id'               => new Twig_Function_Function('Auth\\Auth::is_id'),
            'auth_can'              => new Twig_Function_Function('Auth\\Auth::can'),
            'auth_user'             => new Twig_Function_Function('Auth\\Auth::user'),
            'lang_code'             => new Twig_Function_Function('Fuel\\Core\\Lang::get_lang'),
            'get_flash'             => new Twig_Function_Function('Session::get_flash'),

            'rand'             => new Twig_Function_Function('mt_rand'),
            'icon'              => new Twig_Function_Method($this, 'printIcon'),

            'get_makes'         => new Twig_Function_Function('Helper_Vehicle::get_makes'),
            'get_provinces'     => new Twig_Function_Function('Helper_Vehicle::get_provinces'),

            'sha1'             => new Twig_Function_Function('sha1'),
            'var_dump'     => new Twig_Function_Function('var_dump'),

        );
    }

    public function fetchFrontendLang()
    {
        \Lang::load('frontend', 'frontend');
        return json_encode(\Lang::get('frontend'));
    }

    public function fetchTokenCsrf()
    {
        return \Form::hidden(\Config::get('security.csrf_token_key'), \Security::fetch_token());
    }

    public function printFlashAlert($class)
    {
        $message = \Session::get_flash('message:'.$class, false);

        if(!$message) {
            return null;
        }
        return '<div class="alert alert-'.$class.'">
              <button type="button" class="close" data-dismiss="alert">×</button>
              '.$message.'
            </div>';
    }

    public function printIcon($iconClass)
    {
        return '<i class="icon icon-'.$iconClass.'"></i>';
    }

    /**
     * Provides the url() functionality.  Generates a full url (including
     * domain and index.php).
     *
     * @param   string  URI to make a full URL for (or name of a named route)
     * @param   array   Array of named params for named routes
     * @return  string
     */
    public function url($uri = '', $named_params = array())
    {
        if ($named_uri = Router::get($uri, $named_params))
        {
            $uri = $named_uri;
        }

        return Uri::create($uri);
    }

    public function fuel_environment()
    {
        return Fuel::$env;
    }

    public function fuel_version()
    {
        return Fuel::VERSION;
    }

}
