<?php

namespace Auth;

use Orm\Model;

/**
 * SETI Consultyn S.L.
 * www.seticonsultyn.es
 *
 * Copyright(c) 2011-2013
 *
 * @author    SETI Consultyn S.L. <contacto@seticonsultyn.es>
 * @copyright 2011-2013 SETI Consultyn S.L. http://seticonsultyn.com/copyright.txt
 * @license   SETI Consultyn Software License <license.txt>
 * @link      http://seticonsultyn.es
 */

class Model_Auth_GroupRole extends Model{

    protected static $_table_name = 'auth_groups_roles';

    protected static $_primary_key = array('group_id', 'role_id');

    protected static $_belongs_to = array(
        'group' => array(
            'key_from' => 'group_id',
            'key_to' => 'id',
            'model_to' => 'Auth\\Model_Auth_Group',
            'cascade_delete' => false
        ),
        'role' => array(
            'key_from' => 'role_id',
            'key_to' => 'id',
            'model_to' => 'Auth\\Model_Auth_Role',
            'cascade_delete' => false
        ),
    );




}