<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;
use Fuel\Core\Input;

class Controller_Boletinsaludable_Index extends \Controller_App{

    //Variable para guardar las migas de pan que van a aparecer en las vistas
    private $_bc = array();

    //Array con los elementos del menu que se deben marcar con la clase "active" para que esten seleccionados en el menu.
    private $_option_menu=array('Recetario');

    public function before(){

//        //Se cargan funciones de javascript especificas de esta funcionalidad
        Casset::js('boletinsaludable/index.js');
//
//        //Se marca la navegación en forma de migas de pan. Cada miga de pan la forman dos variables:
//        //  ds  : String a mostrar
//        //  url : url del enlace en modo absoluto
//        $this->_bc[] = array('ds'=>'Inicio','url'=>'/dashboard');

        parent::before();
    }

    public function action_index(){

        $view = View::forge('boletinsaludable/index.twig');

        //Titulo de la vista
        $view->title = "Boletín saludable";

        //Paso de las migas de pan a la vista
        $view->bc = $this->_bc;

        //Paso de las opciones de menu que deben aparecer seleccionadas
        $view->option_menu = $this->_option_menu;


        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "En esta pantalla tendrás acceso a los últimos artículos publicados por los dietistas-nutricionistas del equipo de iNutralia. Un boletín saludable para mantenerte al día";

        $view->articles = $this->ws_article_get();
        
        return Response::forge($view);
    }

    public function post_ver(){

        $view = View::forge('boletinsaludable/ver.twig');

        //Titulo de la vista
        $view->title = "Artículo";

        //Paso de las migas de pan a la vista
        $view->bc = $this->_bc;

        //Paso de las opciones de menu que deben aparecer seleccionadas
        $view->option_menu = $this->_option_menu;

        $article = explode('|',Input::post('article'));

        $view->article_title = $article[1];
        $view->article_excerpt = $article[3];
        // El texto esta en string y lo pasamos a array delimitado por salto de linea
        $view->article_body = explode(PHP_EOL, $article[2]);
        $view->article_published_at = $article[5];
        $view->article_highlight_photo = $article[4];



        return Response::forge($view);
    }


}