<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function index()
    {
        // Con listado dinámino, tomando datos desde la DB
        // Con el constructor de consultas de laravel
        // $users = DB::table('users')->get();

        // dd($users);  // Sirve para parar el proceso y mostar el resultado por pantalla

        // Con eloquent
        $users = User::all();

        // Con listado estático
        /*
        if (request()->has('empty')) {
            $users = [];
        } else {
            $users = [
                'Joel', 'Ellie', 'Tess','Tommy', 'Bill'
            ];
        }*/

        $title = "Listado de usuarios";

        // Forma alternativa para llamar a la vista
        /*
        return view('users.index')
            ->with('users', User::all())
            ->with('title', 'Listado de Usuarios');
        */

        return view('users.index', compact('title', 'users'));
    }

    public function show($id)
    {
        // return view('users.show', compact('id'));
        $user = User::find($id);

        // Condicional para evitar que el usuario busque un registro inexixtente
        if ($user == null){
            return view('errors.404');
        }
        // dd(is_null($user));
        return view('users.show', compact('user'));
    }

    public function create()
    {
        return view('users.create');
    }

    public function store(){

        // recibe los campos del formulario y crea un usuario nuevo

        // $data = request()->all();   // recoge todos los campos son validar nada

        /*
         * Con los datos validados, el método validate() recibe un array asociativo con todas las validaciones,
         * se puede mandar otro array con los mensajes que se quieran mostar, donde las llaves son los nombres de los
         * campos.nombreValidación (name.required) y los valores son los mensajes
         */
        $data = request()->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email', // Con | puedes tener más de una regla, o pasando un array ['required', 'email', '...']
            'password' => ['required','min:6'],
        ], [
            'name.required' => 'El campo "Nombre del usuario" es requerido',
            'email.required' => 'El campo "Email" es requerido',
            'email.unique' => 'Otro usuario stá usando el email, este debe ser único',
            'password.required' => 'El campo "Tu password" es requerido',
            'password.min' => 'El campo "Tu password" debe tener al menos 6 caracteres',
        ]);

        User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
        ]);

        return redirect()->route('users.index');
        // return 'Procesando información ...';
    }

    public function edit(User $user)
    {
        return view('users.edit', ['user' => $user]);
    }

    public function update(User $user){
        $data = request()->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email', // Con | puedes tener más de una regla, o pasando un array ['required', 'email', '...']
            'password' => ['required','min:6'],
        ], [
            'name.required' => 'El campo "Nombre del usuario" es requerido',
            'email.required' => 'El campo "Email" es requerido',
            'email.unique' => 'Otro usuario stá usando el email, este debe ser único',
            'password.required' => 'El campo "Tu password" es requerido',
            'password.min' => 'El campo "Tu password" debe tener al menos 6 caracteres',
        ]);

        $data['password'] = bcrypt($data['password']);

        $user->update($data);

        return redirect()->route('user.show', ['user' => $user]);
    }
}
