<?php

namespace App;

use Illuminate\Notifications\Notifiable;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{

    // protected $table = 'users';
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $casts = [
        //'email_verified_at' => 'datetime',
        'is_admin' => 'boolean',
    ];

    public static function findByEmail($email){
        return static::where(compact('email'))->first();
    }

    public function profession(){
        return $this->belongsTo(Profession::class);
    }

    public function isAdmin(){
        // Comparación directa
        //return $this->email === 'duilio@styde.net';

        // Comparación con función
        return $this->is_admin;
    }
}
