@extends('layout')

@section('title', "Crear usuario")

@section('content')
    <h1>Crear usuario</h1>

    {{--    Saber si se tiene algún error enel formulario   --}}
    {{--
    @if($errors->any())
        <!-- La variable $errors toma TODOS los errores -->
        <div class="alert alert-danger">
            <p>Por favor corrige los siguiente errores:</p>
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    --}}

    <form action="{{route('users.store')}}" method="post">
        {{--
              Add _token (es un input type="hidden" que envia info que solo nuestro serve sabe) para evitar ataques de tipo CSRF
                  <input type="hidden" name="_token" value="F3hukPNtUeW02l3URoLgyM1pd4uQPWazQrSaXQ8h">
        --}}
        {{csrf_field()}}
        {{--
            Para desactivar el csrf_field() se debe ir a /app/Http/kernel.php
            Por la línea 36 aprox.    \App\Http\Middleware\VerifyCsrfToken::class
        --}}
        <div class="form-group">
            <label for="name">Nombre del usuario: </label>
            <input type="text" class="form-control" name="name" id="name" placeholder="Nombres apellidos" value="{{ old('name') }}">

            @if($errors->any() && $errors->has('name')) {{-- Toma la variable $errors y mira si tiene un error en la clave 'name'--}}
                <div class="alert alert-danger">
                    <p>{{ $errors->first('name') }}</p>
                </div>
            @endif

        </div>

        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" class="form-control" name="email" id="email" placeholder="usuario@example.com" value="{{ old('email') }}">

            @if($errors->any() && $errors->has('email')) {{-- Toma la variable $errors y mira si tiene un error en la clave 'name'--}}
            <div class="alert alert-danger">
                <p>{{ $errors->first('email') }}</p>
            </div>
            @endif
        </div>

        <div class="form-group">
            <label for="passwords">Tu password</label>
            <input type="password" class="form-control" name="password" id="passwords" placeholder="Mayor a 6 caracteres">

            @if($errors->any() && $errors->has('password')) {{-- Toma la variable $errors y mira si tiene un error en la clave 'name'--}}
            <div class="alert alert-danger">
                <p>{{ $errors->first('password') }}</p>
            </div>
            @endif
        </div>

        <button class="btn btn-primary" type="submit">Crear usuario</button>
    </form>

    <p>
        <a href="{{ route('users.index') }}">Regresar al listado de usurios</a>
    </p>
@endsection
