@extends('layout')

@section('title', "Editar usuario")

@section('content')
    <h1>Editar usuario</h1>

    <form action="{{route('users.update')}}" method="post">
        {{ method_field('PUT') }} {{-- Método de laravel, que permite realizar una llamada, por medio del formulario, al
                                  método PUT --}}
        {{csrf_field()}}

        <div class="form-group">
            <label for="name">Nombre del usuario: </label>
            <input type="text" class="form-control" name="name" id="name" value="{{ old('name', $user->name) }}">

            @if($errors->any() && $errors->has('name'))
            <div class="alert alert-danger">
                <p>{{ $errors->first('name') }}</p>
            </div>
            @endif

        </div>

        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" class="form-control" name="email" id="email" value="{{ old('email', $user->email) }}">

            @if($errors->any() && $errors->has('email'))
            <div class="alert alert-danger">
                <p>{{ $errors->first('email') }}</p>
            </div>
            @endif
        </div>

        <div class="form-group">
            <label for="passwords">Tu password</label>
            <input type="password" class="form-control" name="password" id="passwords" placeholder="Mayor a 6 caracteres">

            @if($errors->any() && $errors->has('password'))
            <div class="alert alert-danger">
                <p>{{ $errors->first('password') }}</p>
            </div>
            @endif
        </div>

        <button class="btn btn-primary" type="submit">Actualizar usuario</button>
    </form>

    <p>
        <a href="{{ route('users.index') }}">Regresar al listado de usurios</a>
    </p>
@endsection
