@extends('layout')

@section('title', 'Usuarios')

@section('content')
     <h1>{{ $title }}</h1>
        <ul>
            @forelse ($users as $user)
                <li>
                    {{ $user->id }} - {{ $user->name }}, ({{ $user->email  }})
                    <!--
                        url() => Enlaza a rutas arbitrarias dentro de la app
                        También se puden usar ""
                             <a href="{{ url("/usuarios/{$user->id}") }}">Ver detalle</a>
                    -->
                    <!--
                    <a href="{{ url('/usuarios/'.$user->id) }}">Ver detalle</a>
                    -->
                    <!--
                        Con action()
                        <a href="{{ action('UserController@show', ['id' => $user->id]) }}">Ver detalle</a>
                    -->
                    <!--
                        con rutas (name), estas estan definidas en routes/web.php
                    -->
                    <a href="{{ route('users.show', ['id' => $user->id]) }}">Ver detalle</a>
                    <a href="{{ route('users.edit', ['id' => $user->id]) }}">Actualizar usuario</a>
                </li>
            @empty
                <p>No hay usuarios registrados</p>
            @endforelse
        </ul>
@endsection

@section('sidebar')
    @parent
@endsection
