<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\welcomeUserController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/usuarios', 'UserController@index')
    ->name('users.index');

Route::get('/usuarios/{id}', 'UserController@show')
    ->where('id', '[0-9]+')
    ->name('users.show');
// Rutas par la creación de usuarios - Métodos get / post
/*
 * get  -> Solicitar y obtener información
 * post -> Enviar y procesar información
 *
 */
Route::get('/usuarios/nuevo', 'UserController@create')
    ->name('users.create');

Route::post('/usuarios/crear', 'UserController@store')
    ->name('users.store');

Route::get('/saludo/{name}/{nickname?}', 'welcomeUserController');

// Ruta para la edición del usuario, carga los datos
Route::get('/usuarios/{user}/editar', 'UserController@edit')->name('users.edit');

// Ruta para la actualzación en DB de los datos
Route::put('/usuarios/{user}', 'UserController@update')->name('users.update');
