<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function index()
    {
        // Con listado dinámino, tomando datos desde la DB
        // Con el constructor de consultas de laravel
        // $users = DB::table('users')->get();

        // dd($users);  // Sirve para parar el proceso y mostar el resultado por pantalla

        // Con eloquent
        $users = User::all();

        // Con listado estático
        /*
        if (request()->has('empty')) {
            $users = [];
        } else {
            $users = [
                'Joel', 'Ellie', 'Tess','Tommy', 'Bill'
            ];
        }*/

        $title = "Listado de usuarios";

        // Forma alternativa para llamar a la vista
        /*
        return view('users.index')
            ->with('users', User::all())
            ->with('title', 'Listado de Usuarios');
        */

        return view('users.index', compact('title', 'users'));
    }

    public function show($id)
    {
        // return view('users.show', compact('id'));
        $user = User::find($id);

        // Condicional para evitar que el usuario busque un registro inexixtente
        if ($user == null){
            return view('errors.404');
        }
        // dd(is_null($user));
        return view('users.show', compact('user'));
    }

    public function create()
    {
        return view('create');
    }
}
